<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<div class="container py-5">
    <?php if (!empty($posts)): ?>
        <div class="row">
            <?php foreach ($posts as $post): ?>
                <div class="col-lg-4 col-md-6 mb-4">
                    <article class="card h-100 shadow-sm border-0 post-card">
                        <!-- Featured Image -->
                        <a href="<?php echo base_url('blog/view/' . $post->slug); ?>" class="text-decoration-none">
                            <?php if (!empty($post->featured_image)): ?>
                                <img src="<?php echo base_url('uploads/blog/' . $post->featured_image); ?>" 
                                     class="card-img-top" 
                                     alt="<?php echo htmlspecialchars($post->title); ?>"
                                     style="height: 220px; object-fit: cover;">
                            <?php else: ?>
                                <div class="card-img-top bg-light d-flex align-items-center justify-content-center" 
                                     style="height: 220px;">
                                    <i class="fas fa-newspaper fa-4x text-muted"></i>
                                </div>
                            <?php endif; ?>
                        </a>
                        
                        <div class="card-body">
                            <!-- Category Badge -->
                            <?php if (!empty($post->category_name)): ?>
                                <a href="<?php echo base_url('blog/category/' . $post->category_slug); ?>" 
                                   class="badge bg-primary text-decoration-none mb-2">
                                    <?php echo htmlspecialchars($post->category_name); ?>
                                </a>
                            <?php endif; ?>
                            
                            <!-- Post Title -->
                            <h5 class="card-title fw-bold">
                                <a href="<?php echo base_url('blog/view/' . $post->slug); ?>" 
                                   class="text-decoration-none text-dark">
                                    <?php echo htmlspecialchars($post->title); ?>
                                </a>
                            </h5>
                            
                            <!-- Excerpt -->
                            <p class="card-text text-muted">
                                <?php echo htmlspecialchars(character_limiter($post->excerpt, 120)); ?>
                            </p>
                        </div>
                        
                        <!-- Card Footer -->
                        <div class="card-footer bg-white border-0">
                            <div class="d-flex justify-content-between align-items-center">
                                <small class="text-muted">
                                    <i class="far fa-calendar"></i>
                                    <?php echo date('M d, Y', strtotime($post->published_at)); ?>
                                </small>
                                <small class="text-muted">
                                    <i class="far fa-eye"></i>
                                   <?php echo number_format($post->views_count ?? 0); ?> views
                                </small>
                            </div>
                            <div class="mt-2">
                                <small class="text-muted">
                                    <i class="far fa-user"></i>
                                    By <?php echo htmlspecialchars($post->author_name); ?>
                                </small>
                            </div>
                        </div>
                    </article>
                </div>
            <?php endforeach; ?>
        </div>
        
        <!-- Pagination -->
        <?php if (!empty($pagination)): ?>
            <div class="row mt-4">
                <div class="col-12">
                    <nav aria-label="Blog pagination">
                        <?php echo $pagination; ?>
                    </nav>
                </div>
            </div>
        <?php endif; ?>
        
    <?php else: ?>
        <!-- Empty State -->
        <div class="text-center py-5">
            <i class="fas fa-newspaper fa-4x text-muted mb-3"></i>
            <h4 class="text-muted">No Blog Posts Yet</h4>
            <p class="text-muted">Check back soon for updates and stories from our community.</p>
            <a href="<?php echo base_url(); ?>" class="btn btn-primary mt-3">
                <i class="fas fa-home"></i> Back to Home
            </a>
        </div>
    <?php endif; ?>
</div>

<style>
.post-card {
    transition: transform 0.3s, box-shadow 0.3s;
}

.post-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 20px rgba(0,0,0,0.15) !important;
}

.post-card .card-img-top {
    transition: opacity 0.3s;
}

.post-card:hover .card-img-top {
    opacity: 0.9;
}

/* Pagination Styling */
.pagination {
    justify-content: center;
}

.page-link {
    color: #f26124;
    border-color: #dee2e6;
}

.page-link:hover {
    color: #d94f15;
    background-color: #f7e1b0;
    border-color: #f26124;
}

.page-item.active .page-link {
    background-color: #f26124;
    border-color: #f26124;
}
</style>